#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/tllyDj

#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))

float lpNorm(vec3 p, float n)
{
	p = pow(abs(p), vec3(n));
	return pow(p.x+p.y+p.z, 1.0/n);
}

//Fractal Parameters
#define SCALE -2.8
#define MR2 0.3
#define S_VEC  vec4(SCALE,SCALE,SCALE,abs(SCALE))/MR2

float map(vec3 p){
    p.xy *= rot(iTime*0.2);
    p.yz *= rot(iTime*0.1);
    vec4 q = vec4(p,1), q0 = q; 
    for (int i=0; i<10; i++) {
        q.xyz = clamp(q.xyz, -1.0, 1.0) * 2.0 - q.xyz;
        float r2 = pow(lpNorm(q.xyz,16.0),2.0);
        q *= S_VEC*clamp(max(MR2/r2, MR2), 0.0, 0.9);
        q += q0*0.5;
    }
    return 0.8*length(q.xyz)/q.w - 0.005;
}


vec3 calcNormal(vec3 pos){
  vec2 e = vec2(1,-1) * 0.002;
  return normalize(
    e.xyy*map(pos+e.xyy)+e.yyx*map(pos+e.yyx)+ 
    e.yxy*map(pos+e.yxy)+e.xxx*map(pos+e.xxx)
  );
}

float march(vec3 ro, vec3 rd, float near, float far)
{
    float t=near,d;
    for(int i=0;i<50;i++)
    {
        t+=d=map(ro+rd*t);
        if (d<0.001) return t;
        if (t>=far) return far;
    }
    return far;
}

float calcShadow( vec3 light, vec3 ld, float len ) {
	float depth = march( light, ld, 0.0, len );	
	return step( len - depth, 0.01 );
}


void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord* 2.0 - iResolution.xy) / iResolution.y;
    vec3 ro = vec3(0,0,4.5);
    vec3 rd = normalize(vec3(uv,-2.0));
    vec3 col = vec3(0);
	const float maxd = 10.0;
    float t = march(ro,rd,0.0,maxd);
    if(t<maxd)
    {
        vec3 p=ro+rd*t;
        col=vec3(0.9,0.3,0.2)+cos(p*0.5)*0.5+0.5;
        vec3 n = calcNormal(p);      
		vec3 lightPos=vec3(3);
    	vec3 li = lightPos - p;
		float len = length( li );
		li /= len;
		float dif = clamp(dot(n, li), 0.0, 1.0);
        float sha = calcShadow( lightPos, -li, len );
        col *= max(sha*dif, 0.2);
        float rimd = pow(clamp(1.0 - dot(reflect(-li, n), -rd), 0.0, 1.0), 2.5);
		float frn = rimd+2.2*(1.0-rimd);
    	col *= frn*0.8;
        col *= max(0.5+0.5*n.y, 0.0);
        col *= exp2(-2.*pow(max(0.0, 1.0-map(p+n*0.3)/0.3),2.0));
        col += vec3(0.1,0.4,0.9)*pow(clamp(dot(reflect(rd, n), li), 0.0, 1.0), 20.0);
    }
    fragColor.xyz = col;
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


